import 'package:dio/dio.dart';
import 'package:razinsoft_rider/domain/interfaces/ride_preference_service_interface.dart';
import '../../core/config/api_endpoints.dart';
import 'api/dio_client.dart';

class RidePreferenceService implements IRidePreferenceService {
  final DioClient dioClient;

  RidePreferenceService({required this.dioClient});

  @override
  Future<Response> getPreference() async => dioClient.dio.get(
      ApiEndpoints.ridePreference,
    );

}
